function [CL] = signal_return_CL(design)
%signal_return_CL returns coupling leakage.

position_SA = design.element_indices;
position_SA = position_SA(:);
nnn = length(position_SA);
P = repmat(position_SA', nnn, 1);
D = P' - P; % D_ij = d_i - d_j
% ==================== Mutual coupling parameters ====================
c1 = 0.3*exp((1/3)*i*pi);
cc=[];
cc(1)=c1;
for pp=2:100
    cc(pp) = c1*exp(-i*(pp-1)*pi/8)/pp;
end

% ==================== Mutual Coupling matrix computing =====================
M_C = eye(nnn);
for    ppp=1:100
       M_C( abs(D) == ppp) = cc(ppp);
end
% ==================== Coupling Leakage ================================
CL = M_C-diag(diag(M_C));
CL = norm(CL, 'fro')/norm(M_C, 'fro');

end
